# YouTube to Blogger Automation Bot

This Python bot automates the process of fetching popular YouTube videos based on specific queries, downloading their thumbnails, and creating corresponding blog posts on your Blogger website.

## Features

- **Search YouTube** for videos based on specific queries.
- **Rank videos by view count** to find the most popular ones.
- **Download video thumbnails** for visual content in your blog posts.
- **Create and publish blog posts** on Blogger with the video title, thumbnail, description, and a link to the video.

## Setup Instructions

### 1. Google Cloud Project

1. **Create a Google Cloud Project:**
   - Go to the [Google Cloud Console](https://console.cloud.google.com/).
   - Click on the project dropdown at the top and select "New Project."
   - Enter a project name (e.g., `YouTubeToBloggerBot`) and click "Create."

2. **Enable APIs:**
   - Within your project, navigate to **APIs & Services > Library**.
   - Enable the following APIs:
     - **YouTube Data API v3**
     - **Blogger API**

3. **Create OAuth 2.0 Credentials:**
   - Go to **APIs & Services > Credentials**.
   - Click **"Create Credentials" > "OAuth client ID"**.
   - If prompted, set up the OAuth consent screen:
     - Choose **"External"** for user type.
     - Fill in required fields like **Application name**.
     - Save and continue through the steps.
   - **Create OAuth Client ID:**
     - **Application type:** Desktop app
     - **Name:** e.g., `YouTubeToBloggerBot Client`
     - Click **"Create"**.
   - **Download Credentials:**
     - After creation, click **"Download JSON"**.
     - Save this file as `credentials.json` in the root of your project directory (`YouTubeToBloggerBot/credentials.json`).

   > **Important:** Keep `credentials.json` secure and do not share it publicly.

### 2. Install Dependencies

Ensure you have **Python 3.6** or higher installed. Then, install the necessary Python packages using `pip`.

1. **Navigate to Project Directory:**

   ```bash
   cd YouTubeToBloggerBot
